#include "wsc.h"
//#include <windows.h>
#include <string.h>
#include "stdafx.h"
#include "serial.h"
#include "tcpip.h"
#include <winbase.h>

extern TCPIP *TCPIP4999;

serialPort::serialPort(LPCTSTR portNumber)
{
	rec_pointer=0;
	send_pointer=0;
  port=portNumber;
  DWORD dwError;
  DCB PortDCB;
  COMMTIMEOUTS CommTimeouts;

  // Open the serial port.
  hPort = CreateFile (portNumber, // Pointer to the name of the port
                      GENERIC_READ | GENERIC_WRITE,
                                    // Access (read-write) mode
                      0,            // Share mode
                      NULL,         // Pointer to the security attribute
                      OPEN_EXISTING,// How to open the serial port
                      0,            // Port attributes
                      NULL);        // Handle to port with attribute
                                    // to copy

  if ( hPort == INVALID_HANDLE_VALUE ) 
  {
    // Could not open the port.
    MessageBox (0, TEXT("Unable to open the port"), 
                TEXT("Error"), MB_OK);
    dwError = GetLastError ();
    valid=FALSE;
	return;
  }
  PortDCB.DCBlength = sizeof (DCB);     

  SetupComm(hPort, 500000, 1024);
  // Get the default port setting information.
  GetCommState (hPort, &PortDCB);

  // Change the DCB structure settings.
  PortDCB.BaudRate = 115200;              // Current baud 
  PortDCB.fBinary = TRUE;               // Binary mode; no EOF check 
  PortDCB.fParity = FALSE;               // Enable parity checking. //IRN
  PortDCB.fOutxCtsFlow = FALSE;         // No CTS output flow control 
  PortDCB.fOutxDsrFlow = FALSE;         // No DSR output flow control 
  PortDCB.fDtrControl = DTR_CONTROL_DISABLE; 
                                        // DTR flow control type 
  PortDCB.fDsrSensitivity = FALSE;      // DSR sensitivity 
  PortDCB.fTXContinueOnXoff = TRUE;     // XOFF continues Tx was TRUE
  PortDCB.fOutX = FALSE;                // No XON/XOFF out flow control 
  PortDCB.fInX = FALSE;                 // No XON/XOFF in flow control 
  PortDCB.fErrorChar = FALSE;           // Disable error replacement. 
  PortDCB.fNull = FALSE;                // Disable null stripping. 
  PortDCB.fRtsControl = RTS_CONTROL_DISABLE; 
                                        // RTS flow control 
  PortDCB.fAbortOnError = FALSE;        // Do not abort reads/writes on 
                                        // error.
  PortDCB.ByteSize = 8;                 // Number of bits/bytes, 4-8 
  PortDCB.Parity = NOPARITY;            // 0-4=no,odd,even,mark,space 
  PortDCB.StopBits = ONESTOPBIT;        // 0,1,2 = 1, 1.5, 2 
 
  // Configure the port according to the specifications of the DCB 
  // structure.
  if (!SetCommState (hPort, &PortDCB))
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to configure the serial port"), 
                TEXT("Error"), MB_OK);
    dwError = GetLastError ();
    valid=FALSE;
	return;
  }

  // Retrieve the time-out parameters for all read and write operations
  // on the port. 
  GetCommTimeouts (hPort, &CommTimeouts);

  // Change the COMMTIMEOUTS structure settings.
  CommTimeouts.ReadIntervalTimeout =  50;  
  CommTimeouts.ReadTotalTimeoutMultiplier = 2;  
  CommTimeouts.ReadTotalTimeoutConstant = 10;    
  CommTimeouts.WriteTotalTimeoutMultiplier = 10;  
  CommTimeouts.WriteTotalTimeoutConstant = 1000;    



  // Set the time-out parameters for all read and write operations
  // on the port. 
  if (!SetCommTimeouts (hPort, &CommTimeouts))
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to set the time-out parameters"), 
                TEXT("Error"), MB_OK);
    dwError = GetLastError ();
    valid=FALSE;
	return;
  }
	
 

  // Set the time-out parameters for all read and write operations
  // on the port. 


	DWORD dwThreadID;
	HANDLE hReadThread = CreateThread (NULL, 0, PortReadThread, this, 0, 
                                  &dwThreadID);
  if (hReadThread)
  {
    CloseHandle (hReadThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the read thread"), 
                TEXT("Error"), MB_OK);
    dwError = GetLastError ();
  }
  //CeSetThreadPriority(hReadThread,0);
  // Create a read thread for reading data from the communication port.
  valid=TRUE;
}

serialPort::~serialPort()
{

	if (hPort != INVALID_HANDLE_VALUE)
	{
		CloseHandle (hPort);
		hPort = INVALID_HANDLE_VALUE;
	}
}

void serialPort::writeByte(char Byte)
{
  DWORD dwNumBytesWritten;

  WriteFile (hPort,              // Port handle
             &Byte,              // Pointer to the data to write 
             1,                  // Number of bytes to write
             &dwNumBytesWritten, // Pointer to the number of bytes 
                                 // written
             NULL);              // Must be NULL for Windows CE

}

void serialPort::writeString2(char* s,int len)
{
	for(int i=0; i<len; i++) {
		writeByte(s[i]);
	}
}

void serialPort::writeString(char* s)
{

	int len=strlen(s);
	for(int i=0; i<len; i++) {
		writeByte(s[i]);
	}
}

bool serialPort::readByte(char& Byte)
{

	Byte='*';
	if(send_pointer!=rec_pointer) {
		Byte=buffer[send_pointer];
		send_pointer=(send_pointer+1)%BUF_LENGTH;
		return true;
	}
	return false;
}

char serialPort::readByte2()
{
	char blah=buffer[send_pointer];
	if(send_pointer!=rec_pointer) {
		send_pointer=(send_pointer+1)%BUF_LENGTH;
	}
	return blah;
}

int serialPort::readString(char* s, int l)
{
	int num=bufLength();
	if(l<num) {
		num=l;
	}
	strncpy(s,&buffer[send_pointer],num);
	send_pointer=(send_pointer+num)%BUF_LENGTH;
	return num;
}

int serialPort::bufLength()
{
	if(send_pointer==rec_pointer) {
		return 0;
	} else if(rec_pointer>send_pointer) {
		return rec_pointer-send_pointer;
	} else {
		return rec_pointer+BUF_LENGTH-send_pointer;
	}

}

void serialPort::Flush()
{
	/*char tmp;
	while(readByte(tmp));
	*/
	send_pointer=rec_pointer;
}

void serialPort::EmptyInputBuffer()
{
	char tmp;
	while (readByte(tmp)) ;

}


char serialPort::block_read()
{
	char a;
	while(!readByte(a));
	return a;
}




DWORD PortReadThread (LPVOID lpvoid)
{
  char Byte;
  DWORD dwCommModemStatus,
        dwBytesTransferred;
	serialPort *thisSerial=(serialPort*)lpvoid;
  
  // Specify a set of events to be monitored for the port.
   SetCommMask (thisSerial->hPort, EV_RXCHAR | EV_CTS | EV_DSR | EV_RLSD | EV_RING);

  while (thisSerial->hPort != INVALID_HANDLE_VALUE) 
  {
    // Wait for an event to occur for the port.
    WaitCommEvent (thisSerial->hPort, &dwCommModemStatus, 0);

    // Re-specify the set of events to be monitored for the port.
   SetCommMask (thisSerial->hPort, EV_RXCHAR | EV_CTS | EV_DSR | EV_RING);

    if (dwCommModemStatus & EV_RXCHAR) 
    {
      // Loop for waiting for the data.
      do 
      {
        // Read the data from the serial port.
				ReadFile (thisSerial->hPort, &Byte, 1, &dwBytesTransferred, 0) ;

				if(dwBytesTransferred==1) {
					thisSerial->buffer[thisSerial->rec_pointer]=Byte;
					thisSerial->rec_pointer=(thisSerial->rec_pointer+1)%BUF_LENGTH;
					if(thisSerial->rec_pointer==thisSerial->send_pointer) {
						//TCPIP4999->sendData("WRAPPED!!!\r\n");
						thisSerial->send_pointer=(thisSerial->send_pointer+1)%BUF_LENGTH;
					}
				}

      } while (dwBytesTransferred == 1);
	  Sleep(0);

			// Retrieve modem control-register values.
			//GetCommModemStatus (thisSerial->hPort, &dwCommModemStatus);

    }

  }

  return 0;
}
